(defmeth corresp-proto :visualize ()
  (if (not (eq current-object self)) (setcm self))
  (let* ((NR (send self :NRows))
         (NC (send self :NCols))
         (NC-NR (+ NC NR))
         (coordinates (bind-rows (send self :norm-rows)
                                 (send self :norm-cols)))
         (cols-coordinates (column-list Coordinates))
         (contributions (bind-rows (send self :rpi)
                                  (send self :cpi)))
         (cols-contribution (column-list contributions))
         (cosines (bind-rows (send self :rsc)
                                 (send self :csc)))
         (cols-cosines (column-list cosines))
         
          (ndim (send self :maxdim))
          (Singular-Values (second (send self :GSVD)))
          (Inertias (^ Singular-values 2))
          (Chi-Sq (* 1000 (sum (send self :data)) Inertias))
          (Tot-Chi-Sq (sum Chi-sq))
          (Percent-Chi-Sq (* 100 (/ Chi-Sq Tot-Chi-Sq)))
          (CumPercent (* 100 (/ (cumsum Chi-Sq) Tot-Chi-sq)))
         ;(dim-labels (combine '("Dim1" "Dim2" "Dim3")
         ;                      (repeat "" (- (send self :maxdim) 3))))
         (dim-labels (mapcar #'(lambda (i) (format nil "Dim~d" i)) 
                        (1+ (iseq (send self :maxdim)))))
         (my-data (send self :data-object))
         (freq-way-names (send my-data :freq-way-names)) 
         (row-name (if (first freq-way-names)
                       (first freq-way-names)
                       "Rows"))
         (col-name (if (second freq-way-names)
                       (second freq-way-names)
                       "Columns"))
         (freq-way-names (list row-name col-name))
         (level-labels (list (send self :labels) 
                             (send self :active-variables'(numeric))))
         (deviations (combine (send current-model :deviation)));residuals
         (mean-dev (mean deviations))
         (std-dev (standard-deviation deviations))
             (d (send self :Dimension))
         (Row-Profiles (* (%* (inverse (diagonal (send self :Row-Mass)))
                              (send self :Table)) 100))
         (Col-Profiles (* (%* (send self :Table)
                              (inverse (diagonal (send self :Col-Mass)))) 100))
         (Row-sq-cos (select (send self :RSC)
                             (iseq (send self :Nrows))
                             (iseq d)))
         (Col-sq-cos (select (send self :CSC)
                             (iseq (send self :Ncols))
                             (iseq d)))
         (Row-Quality (mapcar #'sum (row-list Row-sq-cos)))
         (Col-Quality (mapcar #'sum (row-list Col-sq-cos)))
(quality (combine row-quality col-quality))

        (mosaic-data (sort-and-permute (col (send self :norm-rows) 0)
                                        (send my-data :active-data-matrix '(numeric)) 'descending))
         (mosaic-data (combine (transpose 
                                (sort-and-permute (col (send self :norm-cols) 0)
                                        (transpose mosaic-data)))))
         (mosaic-freq-way-names (append
                                 (list (reverse (select (first level-labels) 
                                         (order (col (send self :norm-rows) 0)))))
                               (list  (select (second level-labels)
                                         (order (col (send self :norm-cols) 0))))))
         (mosaic-deviations 
          (map-elements '/ (- (send my-data :active-data-matrix '(numeric))
                              (chisq-expected (send my-data :active-data-matrix '(numeric))))
                       (sqrt (chisq-expected (send my-data :active-data-matrix '(numeric))))))
         (mosaic-deviations (sort-and-permute (col (send self :norm-rows) 0)
                                        mosaic-deviations 'descending))
         (mosaic-deviations (combine (transpose (sort-and-permute 
                                        (col (send self :norm-cols) 0)
                                        (transpose mosaic-deviations)))))
         (mp 
          (if (or (> nr 12) (> nc 12)) nil  
          (mosaic-plot mosaic-data
                          (list (send my-data :nobs)
                                (send my-data :active-nvar '(numeric)) 
                                ) 
                          :freq t 
                          :connect-button t
                          :color-values mosaic-deviations
                          :way-labels freq-way-names 
                          :level-labels mosaic-freq-way-names
                          :standardize nil
                          :show nil))
            )
        (scatmat (scatterplot-matrix (select cols-coordinates (iseq d))
                              :show nil
                              :title "Scatterplot Matrix"
                              :variable-labels dim-labels
                              ))

         (spin-plot (spin-plot cols-coordinates
                              :show nil
                              :title "Spinplot"
                              :variable-labels dim-labels))
                   
         (scatterplot (bubble-biplot quality
                                   cols-coordinates
                                 :show nil
                              :title "Scatterplot"
                              :variable-labels dim-labels))
         (boxplot   (boxplot (select cols-coordinates (iseq d))
                             :show nil
                             :connect-points t
                             :title "Box Plot"
                             :variable-labels dim-labels))
         (obs-list (name-list (combine (send self :labels)
                                       (send self :variables))
                              :show nil
                              :title "Rows and Columns"))

         (scree-plot 
              (plot-points (iseq 1 ndim)
                        inertias ;(^ (second (send self :gsvd)) 2)
                       :show nil
                       :title "Scree Plot"
                       :variable-labels (list "Dimension" "Inertia")))
           (sp (spread-plot 
                      (matrix '(2 4)
                          (list obs-list scatmat  spin-plot scatterplot 
                                nil      boxplot  mp        scree-plot))
                :rel-widths (list .4 1 1 1)
                :rel-heights (list 1 1)
                :span-down (matrix '(2 4) (list 2 1 1 1 0 1 (if mp 0 1) 1))
                :span-right (matrix '(2 4) (list 1 1 1 1 
                                                 0 (if mp 1 2) (if mp 1 0) 1))))
        

        (plots (list boxplot scatterplot scatmat spin-plot obs-list))
         
         )
    (mapcar #'(lambda (plots) 
                (send plots :point-label (iseq NR) (send self :labels))
                (send plots :point-label (+ NR (iseq Nc)) (send self :variables))           
                (send plots :adjust-to-data)
                (send plots :linked t)         
                (send plots :point-color  (iseq NR) 'blue)
                (send plots :point-color (+ NR (iseq Nc)) 'red)
                (send plots :point-symbol (iseq NR) 'square)
                (send plots :point-symbol (+ NR (iseq Nc)) 'cross)
                (send plots :use-color t)    
                (send plots :showing-labels t)) plots)                   


            (send scatterplot :add-lines
              (column-list 
               (sort-and-permute
                (select (first (column-list coordinates)) (iseq nr))
                (select coordinates 
                        (iseq nr) 
                        (iseq (array-dimension coordinates 1))))) :color 'blue)
      (send scatterplot :add-lines
              (column-list 
               (sort-and-permute
                (select (first (column-list coordinates)) (iseq nr (- (+ nr nc) 1)))
                (select coordinates 
                        (iseq nr (- (+ nr nc) 1))
                        (iseq (array-dimension coordinates 1))))) :color 'red)


    ;**SCREE***
    (send scree-plot :showing-labels t)
    (send scree-plot :menu nil)
    (send scree-plot :range 0 1 (send self :maxdim))
    (send scree-plot :x-axis t t (send self :maxdim))
    (send scree-plot :y-axis t t 2)
    (send scree-plot :mouse-mode 'brushing)
    (send scree-plot :point-state 0 'selected)
    (send scree-plot :adjust-to-data :draw nil)
    (send scree-plot :plot-buttons :new-x nil :new-y nil)
    (send scree-plot :add-lines 
          (list (iseq 1 ndim) (^ (second (send self :gsvd)) 2))
          :draw nil :color 'red)
    (send scree-plot :point-color (iseq ndim) 'red)
    (mapcar #'(lambda (i)
                (send scree-plot :point-label i
                      (cond
                        ((> i 0)
                         (format nil "~5,4f, ~5,4f, ~5,4f" 
                                 (select inertias i) 
                                 (select percent-chi-sq i)
                                 (select cumpercent i)))
                        (t
                         (format nil "~5,4f, ~5,4f"
                                 (select inertias i) 
                                 (select percent-chi-sq i))))))
              (iseq (send scree-plot :num-points)))



;**SCATMAT**
(when (> ndim 2)
          (send scatmat :add-mouse-mode 'focus-on-variables
                :title "Focus On Variables"
                :click :do-new-variable-focus
                :cursor 'finger)
          (send scatmat :mouse-mode 'focus-on-variables)
          (send scatmat :plot-buttons :new-x nil :new-y nil)
          (send scatmat :menu-template 
                '(SHOWING-LABELS MOUSE RESIZE-BRUSH DASH SYMBOL COLOR))
          (send scatmat :new-menu)
          ;LINK, ERASE-SELECTION, FOCUS-ON-SELECTION, and SHOW-ALL removed 
          ;from each plot's menu because they dont work with boxplot

          (defmeth scatmat :update-plotcell (i j args)
            (when (and (= i 1) (= j 1))
                  (send self :point-state (iseq (send self :num-points))
                        (first args))))

          (defmeth scatmat :adjust-points-in-rect (&rest args)
            (apply #'call-next-method args)
            (send sp :update-spreadplot 
                  0 4 (send self :point-state (iseq NC-Nr)) (send self :mouse-mode)))

          (defmeth scatmat :do-brush-click (&rest args)
            (send sp :update-spreadplot 0 4 nil 0)
            (apply #'call-next-method args))
          
          (defmeth scatmat :set-selection-color ()
            (call-next-method)
            (send self :point-color (first (send self :selection)))
            (send sp :update-spreadplot 0 4 (send self :point-state (iseq NC-Nr))
                  'color (send self :point-color (first (send self :selection)))))
          
          (defmeth scatmat :set-selection-symbol ()
            (call-next-method)
            (send self :point-color (first (send self :selection)))
            (send sp :update-spreadplot 0 4 (send self :point-state (iseq NC-Nr)) 
                  'symbol (send self :point-symbol (first (send self :selection)))))
          
;**SPIN-PLOT

          ;(send spin-plot :depth-cuing nil)
          (send spin-plot :scale-type 'fixed);xls bug work-around
          (send spin-plot :mouse-mode 'hand-rotate)
          ;(send spin-plot :scale-constant 1.5 :draw nil)
          (send spin-plot :scale-type 'centroid-fixed)
          (send spin-plot :menu-template 
                '(SHOWING-LABELS MOUSE RESIZE-BRUSH DASH 
                                 SYMBOL COLOR DASH FASTER SLOWER AXES))
          (send spin-plot :new-menu)
          ;(send spin-plot :add-box)
          (send spin-plot :switch-add-box)
          (setf dimension-lengths 
                (mapcar #'max (abs (send spin-plot :range (iseq ndim)))))
          
          (if (> (send spin-plot :num-variables) 3)
              (send spin-plot :plot-buttons :margin nil :new-z t :box t)
              (send spin-plot :plot-buttons :margin nil :new-x nil 
                    :new-y nil :box t)) 
          
          ;(defmeth spin-plot :add-box (&key (draw t))
            ;(call-next-method :draw draw)
            ;(send self :add-rays rays :ray-color 'red :no-points t))
          
          
          (defmeth spin-plot :update-plotcell (i j args)
            (when (and (= i 0) (= j 0))
                  (let* ((cur-var-nums (remove-duplicates (first args)))
                         (cur-var-names (remove-duplicates 
                                         (first (second args))  :test 'equal))
                         (numvars (send self :num-variables))
                         )
                    (when (<= (length cur-var-nums) 2)
                          (setf cur-var-nums 
                                (select 
                                 (combine cur-var-nums 
                                          (set-difference (send self :current-variables)
                                                          cur-var-nums))
                                 (iseq 3)))
                          (setf cur-var-names 
                                (select (send self :variable-labels)
                                        cur-var-nums)))
                    (when (or (= (length cur-var-nums) 3)
                              (and (= (length cur-var-nums) 4)
                                   (= (third (send self :current-variables)) 
                                      (- numvars 1))))
                          (when (= (length cur-var-nums) 4)
                                (setf cur-var-nums (select cur-var-nums '(0 1 2)))
                                (setf cur-var-names 
                                      (select cur-var-names '(0 1 2)))
                                )
                          (apply #'send self  :current-variables cur-var-nums)
                          (send self :set-variables-with-labels cur-var-nums
                                cur-var-names)
                          (send self :transformation nil :draw nil)
                          (send self :add-box)
                          (when (matrixp (send self :slot-value 'rotation-type))
                                (send self :slot-value 'rotation-type 'yawing))
                          (send self :redraw)
                          )))
            
            (when (and (= i 1) (= j 1))
                  (send self :point-state (iseq NC-Nr) (first args)))
            )

          (defmeth spin-plot :adjust-points-in-rect (&rest args)
            (apply #'call-next-method args)
            (send sp :update-spreadplot 
                  0 1 (send self :point-state (iseq NC-Nr)) (send self :mouse-mode))
            )
          
          (defmeth spin-plot :do-brush-click (&rest args)
            (send sp :update-spreadplot 0 1 nil 0)
            (apply #'call-next-method args)
            )

          (defmeth spin-plot :set-selection-color ()
            (call-next-method)
            (send self :point-color (first (send self :selection)))
            (send sp :update-spreadplot 0 1 (send self :point-state (iseq NC-Nr)) 
                  'color
                  (send self :point-color (first (send self :selection)))))
          
          (defmeth spin-plot :set-selection-symbol ()
            (call-next-method)
            (send self :point-color (first (send self :selection)))
            (send sp :update-spreadplot 0 1 (send self :point-state (iseq NC-Nr)) 
                  'symbol
                  (send self :point-symbol (first (send self :selection)))))
          
          (defmeth spin-plot :show-new-var (axis variable)
            (let* ((var-num (position variable (send self :variable-labels)))
                   (cur-vars (send self :current-variables))
                   (cur-var-names nil)
                   (idling (send self :idle-on))
                   )
              (cond
                ((equal (string-downcase axis) "x") 
                 (setf (select cur-vars 0) var-num))
                ((equal (string-downcase axis) "y") 
                 (setf (select cur-vars 1) var-num))
                ((equal (string-downcase axis) "z") 
                 (setf (select cur-vars 2) var-num))
                )
              (setf cur-var-names (select (send self :variable-labels) cur-vars))
              (send self :idle-on nil)
              (send self :transformation nil)
              (apply #'send self :current-variables cur-vars)
              (send self :set-variables-with-labels cur-vars cur-var-names)
              ; (send spin-plot :add-rays rays :ray-labels variable-labels)
              (send self :redraw)
              (send self :idle-on idling)))

         (defmeth spin-plot :plot-help ()
            (plot-help-window (strcat "Help for " (send self :title)))
            
(paste-plot-help (format nil "Spinning Plot shows row and column coordinates in 3-dimensional scatterplot. The axes of plot are tripples of AC dimensions.~2%"))
            (show-plot-help)
            (call-next-method :flush nil))
          
          
      )                  
;**SCATTERPLOT
    (send scatterplot :adjust-scatterplot-to-data 'centroid-fixed)
    (send scatterplot :plot-buttons)
    (send scatterplot :mouse-mode 'selecting)
    (send scatterplot :menu-template 
      '(SHOWING-LABELS MOUSE RESIZE-BRUSH DASH SYMBOL COLOR ))

    (send scatterplot :new-menu)
    (send scatterplot :scale (iseq ndim) 
          (/ (send scatterplot :scale (iseq ndim)) 1.3))
    
    (defmeth scatterplot :adjust-points-in-rect (&rest args)
       (apply #'call-next-method args)
       (send sp :update-spreadplot 
             0 2 (send self :point-state (iseq NC-Nr)) 
             (send self :mouse-mode))
      )

    (defmeth scatterplot :do-brush-click (&rest args)
      (send sp :update-spreadplot 0 2 nil 0)
      (apply #'call-next-method args)
      )

    (defmeth scatterplot :set-selection-color ()
      (call-next-method)
      (send self :point-color (first (send self :selection)))
      (send sp :update-spreadplot 0 2 (send self :point-state (iseq NC-Nr)) 
            'color
             (send self :point-color (first (send self :selection)))))

    (defmeth scatterplot :set-selection-symbol ()
      (call-next-method)
      (send self :point-color (first (send self :selection)))
      (send sp :update-spreadplot 0 2 (send self :point-state (iseq NC-Nr)) 
            'symbol
             (send self :point-symbol (first (send self :selection)))))
 
    (defmeth scatterplot :update-plotcell (i j args)
      (when (and (= i 0) (= j 0));when coming from scatmat
            (let* ((cur-var-nums (remove-duplicates (first args)))
                   (mx (select (column-list coordinates) (min cur-var-nums))))
              (when (= (length cur-var-nums) 2)
                    (send self :start-buffering)
                    (send scatterplot :clear-lines)
                    (send scatterplot :add-lines
                          (column-list 
                           (sort-and-permute
                            (select mx (iseq nr))
                            (select coordinates 
                                    (iseq nr) 
                                    (iseq (array-dimension coordinates 1))))) :color 'blue)
                    (send scatterplot :add-lines
                          (column-list 
                           (sort-and-permute
                            (select mx (iseq nr (- (+ nr nc) 1)))
                            (select coordinates 
                                    (iseq nr (- (+ nr nc) 1))
                                    (iseq (array-dimension coordinates 1))))) :color 'red) 
                    (send self :current-variables 
                          (first cur-var-nums)  (second cur-var-nums) 
                          :draw nil)
                    (apply #' send self :y-axis (send self :y-axis))  
                    (send self :buffer-to-screen)     
            )))
      (when (and (= i 1) (= j 1))
            (send self :point-state (iseq NC-Nr) (first args))))                      

    
 
    (defmeth scatterplot :plot-help ()
            (plot-help-window (strcat "Help for " (send self :title)))
(paste-plot-help (format nil "Scatteplot of row and column coordinates in pairs of AC dimensions."))
            (show-plot-help)            (call-next-method :flush nil))



;**OBS-LIST

    (send obs-list :menu-template '(MOUSE DASH COLOR))
    (send obs-list :new-menu)
    
    (defmeth obs-list :update-plotcell (i j args)
      (when (and (= i 1) (= j 1))
            (send self :point-state (iseq NC-Nr) (first args))))


    (defmeth obs-list :adjust-points-in-rect (&rest args)
       (apply #'call-next-method args)
       (send sp :update-spreadplot 
             1 0 (send self :point-state (iseq NC-Nr)) (send self :mouse-mode))
       )

    (defmeth obs-list :do-brush-click (&rest args)
      (send sp :update-spreadplot 1 0 nil 0)
      (apply #'call-next-method args)
      )

    (defmeth obs-list :set-selection-color ()
      (call-next-method)
      (send self :point-color (first (send self :selection)))
      (send sp :update-spreadplot 1 0 (send self :point-state (iseq NC-Nr)) 
            'color
             (send self :point-color (first (send self :selection)))))


    (defmeth obs-list :plot-help ()
            (plot-help-window (strcat "Help for " (send self :title)))
(paste-plot-help (format nil "This window shows row and column names."))

            (show-plot-help)            (call-next-method :flush nil))

    (send obs-list :fix-name-list)

;**BOXPLOT
    (send boxplot :new-menu "BoxPlot" 
              :items '(SHOWING-LABELS MOUSE RESIZE-BRUSH DASH  
                            SYMBOL COLOR))
    (send boxplot :connect-points t)
    (send boxplot :mouse-mode 'brushing)

(mapcar #'(lambda (x) (send boxplot :point-symbol (+ (* x Nr) (* (- x 1) Nc)(iseq Nc)) 'cross)) (iseq 1 ndim))

(mapcar #'(lambda (x) (send boxplot :point-color (+ (* x Nr) (* (- x 1) Nc)(iseq Nc)) 'red)) (iseq 1 ndim))

    (defmeth boxplot :update-plotcell (i j args)
      (when (and (= i 0) (= j 0));when coming from scatmat
            (let* ((var-nums (remove-duplicates (first args)))
                   (num-vars (length var-nums))
                   (my-args (second args))
                   (var-labs (remove-duplicates (first my-args) :test 'equal))
                   (select-order
                    (combine (sort-and-permute 
                              var-nums (matrix (list num-vars 1) 
                                               (iseq num-vars)))))
                   (var-labs (select var-labs select-order))
                   (data (select (second my-args) select-order)))
              (when (= (length var-labs) 1)
                    (setf data (list (first data))))
              (send self :new-plot data :variable-labels var-labs)
              (send self :point-color (+ nr (iseq Nc)) 'red)
              (send self :point-symbol (+ nr (iseq Nc)) 'cross)
              ))
      (when (or (and (= i 0) (= j 4));when scatmat select/brush mouse-mode
                (and (= i 0) (= j 1));spinplot
                (and (= i 0) (= j 2));scatterplot
                (and (= i 1) (= j 0)));list-obs
            (cond
              ((first args)
               (let* ((hilited 
                       (which (map-elements #'eq 'hilited (first args))))
                      (selected 
                       (which (map-elements #'eq 'selected (first args))))
                      (normal 
                       (which (map-elements #'eq 'normal (first args))))
                      (mode (second args))
                      (states (remove-duplicates (first args) :test 'equal))
                      )
                 (when (equal mode 'brushing)
                       (if selected
                           (send self :adjust-points  
                                 selected 'selected  mode)
                           (send self :adjust-points  
                                 hilited  'hilited  mode))
                       )
                 (when (equal mode 'selecting)
                       (when (and (= 1 (length states)) 
                                  (equal (first states) 'normal))
                             (send self :point-state 
                                   (iseq (send self :num-points)) 'normal)
                             (send self :adjust-points 
                                   (first args) 'normal mode))
                       (send self :adjust-points  
                             normal   'normal   mode)
                       (send self :adjust-points 
                             selected 'selected mode)
                       )
                 
                 (when (equal mode 'color)
                       (send self :point-color  selected (third args))
                       (send self :propagate-selection
                             selected 'selected NC-Nr ndim 
                             'selecting :color (third args)))
                 (when (equal mode 'symbol)
                       (send self :point-symbol selected (third args))
                       (send self :propagate-selection
                             selected 'selected Nc-Nr ndim 
                             'selecting :symbol (third args)))
                 ))
              (t
               (send self :unselect-all-points)
               (send self :change-plot)
               ))
            ))
     
	(send spin-plot :multiply-scaled-ranges .5)
     (defmeth boxplot :adjust-points-in-rect (&rest args)
       (apply #'call-next-method args)
       (send sp :update-spreadplot 1 1 (send self :point-state (iseq NC-Nr)))
       )
    

(defmeth boxplot :plot-help () 
            (plot-help-window (strcat "Help for " (send self :title)))
            
(paste-plot-help (format nil "Boxplot of row and column coordinartes  in AC dimensions.~%"))
            (show-plot-help)
            (call-next-method :flush nil))

;;;***OPTIONS***

(setf Options (send menu-proto :new "Options"))

(setf row-item (send menu-item-proto :new "Rows"
                     :action #'(lambda () (mapcar #'(lambda (plots2)
                    (send plots2 :clear)
                    (send plots2 :add-points (column-list (send self :norm-rows))
                                :point-labels (send self :labels))
                    (send plots2 :adjust-to-data)                                                 (send plots2 :use-color t) 
                    (send plots2 :point-color (iseq nr) 'blue) 
                    (send plots2 :point-symbol (iseq nr) 'square) 
                    (send boxplot :new-plot (column-list (send self :norm-rows)) :point-labels (send self :labels))
                    (send boxplot :point-color (iseq (* ndim nr)) 'blue)                                       (send boxplot :point-symbol (iseq (* ndim nr)) 'square)                                                          
                         (send plots2 :redraw)
                                                                                                            )
  (list scatterplot scatmat spin-plot obs-list)))))

  (setf col-item (send menu-item-proto :new "Columns"
                       :action #'(lambda () (mapcar #'(lambda (plots2)
                    (send plots2 :clear)
                    (send plots2 :add-points (column-list (send self :norm-cols))
                                 :point-labels (send self :variables))
                    (send plots2 :adjust-to-data)                                                 (send plots2 :use-color t) 
                    (send plots2 :point-color (iseq nc) 'red) 
                    (send plots2 :point-symbol (iseq nc) 'cross) 
                    (send boxplot :new-plot (column-list (send self :norm-rows)) :point-labels (send self :variables))
                    (send boxplot :point-color (iseq (* ndim nc)) 'red)                           (send boxplot :point-symbol (iseq (* ndim nc)) 'cross)                            
                         (send plots2 :redraw)
                                                                                                            )
  (list scatterplot scatmat spin-plot obs-list)))))

 (setf row-col-item (send menu-item-proto :new "Rows and Columns"                           :action #'(lambda () (mapcar #'(lambda (plots2)
                 (send plots2 :clear)
                 (send plots2 :add-points cols-coordinates) 
                 (send plots2 :point-color  (iseq NR) 'blue)
                (send plots2 :point-color (+ NR (iseq Nc)) 'red)
                (send plots2 :point-symbol (iseq NR) 'square)
                (send plots2 :point-symbol (+ NR (iseq Nc)) 'cross)
                (send plots2 :use-color t)    
                (send plots2 :adjust-to-data)                                                 (send plots2 :point-label (iseq NR) (send self :labels))
                (send plots2 :point-label (+ NR (iseq Nc)) (send self :variables))                                                                                  (send boxplot :new-plot cols-coordinates) 
                (send boxplot :point-color (+ nr (iseq (* ndim nc))) 'red)                    (send boxplot :point-symbol (+ nr (iseq (* ndim nc))) 'cross) 
                (send boxplot :point-label (iseq  nr) (send self :labels))
(send boxplot :point-label (+ nr (iseq  nc)) (send self :variables))
                         (send plots2 :redraw)
                                                                                                            )
  (list scatterplot scatmat spin-plot obs-list)))))


(send Options :append-items row-item col-item row-col-item)
(send Options :install)
      (send sp :show-spreadplot)

)
    )

